Option Explicit

' Parameter sematics: 
'   no parameter (or a value of 0) indicates default operation, 
'   a value of 1 indicates, enhanced tracing 
Dim parm, fso, parmFileName, parmFile, prefFileName
If WScript.Arguments.Count = 0 Then
   parm = 0 
Else
   parm = Wscript.Arguments(0)
End If

' Read in all of the lines of the preferences file if it exists
Set fso = CreateObject("Scripting.FileSystemObject")

parmFileName = "CuttingBoard.parm"
Set parmFile = FSO.OpenTextFile(parmFileName, 2, True)
parmFile.WriteLine(parm)
parmFile.Close

prefFileName = "preferences.xml"
If fso.FileExists(prefFileName) Then
  Dim dict, file, row, line
  Const ForReading = 1
  Set dict = CreateObject("Scripting.Dictionary")
  Set file = fso.OpenTextFile(prefFileName, ForReading)
  row = 0

  Do Until file.AtEndOfStream
    line = file.Readline
    dict.Add row, line
    row = row + 1
  Loop

  file.Close
  Set file = Nothing

  ' Loop over the preference key-value pairs until we find the value for the key, ArtifactDirectory
  Dim ore, oMatch, dirKey, key, value, dataDir
  Set ore = New RegExp
  ore.Pattern = ".*[^=]=""(.*[^ ])"" .*[^""]""(.*[^ ])""/>"
  ore.Global  = True
  dirKey = "ArtifactDirectory"

  For Each line in dict.Items
    Set oMatch = ore.Execute( line )
    If oMatch.Count = 1 Then
      key = oMatch.Item(0).Submatches(0)
      value = oMatch.Item(0).Submatches(1)
      If StrComp(dirKey, key) = 0 Then
        dataDir = value
      End If
    End If  
  Next

  Set dict = Nothing
  Set ore = Nothing
  Set oMatch = Nothing

  ' Update the application if available (expects the current working directory to contain the preferences.xml file)
  Dim updateDir, cbDir
  updateDir = dataDir & "\update"
  cbDir = updateDir & "\cuttingboard"
  If fso.FolderExists(cbDir) Then
    fso.CopyFolder cbDir, ".", TRUE
    fso.DeleteFolder updateDir, TRUE
    fso.DeleteFile dataDir & "\help\help.html"
    fso.DeleteFile dataDir & "\import\DietaryReferenceTemplate.xml"
    fso.DeleteFile dataDir & "\import\MealTemplate.xml"
    fso.DeleteFile dataDir & "\import\RecipeTemplate.xml"   
  End If
  Set fso = Nothing
End If

' Launch the application 
' Run doesn't take parameters and Exec provides an unwelcome command terminal, so we use:
'   - the CuttingBoard.parm file to pass in a runtime parameter, and
'   - the CuttingBoard.bat to enact that parameter and encapsulate the necessary runtime options
Dim wso
Set wso = CreateObject("WScript.Shell")
wso.Run "CuttingBoard.bat", 0
Set wso = Nothing
WScript.Quit