#! /bin/sh

# Read in all of the lines of the preferences file.
# Loop over the preference key-value pairs until we find the value for the key, ArtifactDirectory.
# Update the application if available (expects the current working directory to contain the preferences.xml file).

file=preferences.xml

if [ -f "$file" ] ; then
  while read line
  do
    dataDir=`echo "$line" | awk -v FS="ArtifactDirectory" 'NF>1{print $2}' | awk -v FS="\"" 'NF>1{print $3}'`
    if [ ! -z "$dataDir" ]
    then
      updateDir=$dataDir/update
      cbDir=$updateDir/cuttingboard
      if [ -d $cbDir ]
      then
        cp -r "$cbDir/"* .
        rm -rf "$updateDir"
        rm -f  "$dataDir/help/help.html"
        rm -f  "$dataDir/import/DietaryReferenceTemplate.xml"
        rm -f  "$dataDir/import/MealTemplate.xml"
        rm -f  "$dataDir/import/RecipeTemplate.xml"   
      fi
    fi
  done <$file
fi

# Launch the application

( nohup java -jar cuttingboard.jar >/dev/null 2>&1 & )

#java -jar cuttingboard.jar

#rm -f $HOME/cuttingboard/outputPrevious.log
#mv -f $HOME/cuttingboard/output.log $HOME/cuttingboard/outputPrevious.log
#touch $HOME/cuttingboard/output.log
#java -Dorg.entangledbits.cuttingboard.preferencesFile=$HOME/cuttingboard/preferences.xml -Djava.util.logging.config.file=$HOME/cuttingboard/ical4jLogging.properties -jar cuttingboard.jar >>$HOME/cuttingboard/output.log 2>&1